/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.browserNotifications;

import com.aptana.core.logging.IdeLog;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.browserNotifications.AbstractBrowserNotification;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserNotificationProxy
extends AbstractBrowserNotification {
    private IConfigurationElement element;
    private AbstractBrowserNotification contributorClass;
    private static final String ATT_CLASS = "class";
    private static final String ATT_NOTIFICATION_TARGET = "notificationTarget";

    public BrowserNotificationProxy(IConfigurationElement element) {
        this.element = element;
    }

    @Override
    public void start() {
        try {
            this.loadElement();
            this.contributorClass.start();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
        }
    }

    @Override
    public List<String> getNotificationTargets() {
        try {
            this.loadElement();
            return this.contributorClass.getNotificationTargets();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void setNotificationTargets(String targets) {
        try {
            this.loadElement();
            this.contributorClass.setNotificationTargets(targets);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
        }
    }

    private synchronized void loadElement() throws CoreException {
        if (this.contributorClass == null) {
            this.contributorClass = (AbstractBrowserNotification)this.element.createExecutableExtension(ATT_CLASS);
            this.contributorClass.setNotificationTargets(this.element.getAttribute(ATT_NOTIFICATION_TARGET));
        }
    }

    @Override
    protected void notifyTargets(String eventId, String eventType, String data) {
        try {
            this.loadElement();
            this.contributorClass.notifyTargets(eventId, eventType, data);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
        }
    }

    @Override
    protected void notifyTargets(String eventId, String eventType, String data, boolean notifyInUIThread) {
        try {
            this.loadElement();
            this.contributorClass.notifyTargets(eventId, eventType, data, notifyInUIThread);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            this.loadElement();
            this.contributorClass.stop();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
        }
    }
}

